%------------------------------------------------------------------------------
% File     : DAT200^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Data Structures
% Problem  : Sorted list operations 47
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [Lam09] Lammich (2009), Collections Framework
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : sorted_list_operations__47.p [Bla16]

% Status   : Theorem
% Rating   : 1.00 v7.1.0
% Syntax   : Number of formulae    :  319 (  85 unt;  39 typ;   0 def)
%            Number of atoms       :  812 ( 331 equ;   0 cnn)
%            Maximal formula atoms :   13 (   2 avg)
%            Number of connectives : 4522 ( 116   ~;  10   |;  92   &;3867   @)
%                                         (   0 <=>; 437  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   25 (   8 avg)
%            Number of types       :    2 (   1 usr)
%            Number of type conns  :  178 ( 178   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   41 (  38 usr;   8 con; 0-4 aty)
%            Number of variables   : 1171 (  42   ^;1041   !;  59   ?;1171   :)
%                                         (  29  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:40:24.399
%------------------------------------------------------------------------------
%----Could-be-implicit typings (4)
thf(ty_t_List_Olist,type,
    list: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

thf(ty_tf_a,type,
    a: $tType ).

%----Explicit typings (35)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Osemilattice__inf,type,
    semilattice_inf: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_Lattices_Oinf__class_Oinf,type,
    inf_inf: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Ocan__select,type,
    can_select: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) > $o ) ).

thf(sy_c_List_Odistinct,type,
    distinct: 
      !>[A: $tType] : ( ( list @ A ) > $o ) ).

thf(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olinorder__class_Osorted,type,
    linorder_sorted: 
      !>[A: $tType] : ( ( list @ A ) > $o ) ).

thf(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : ( list @ A ) ).

thf(sy_c_List_Olist_Ohd,type,
    hd: 
      !>[A: $tType] : ( ( list @ A ) > A ) ).

thf(sy_c_List_Olist_Oset,type,
    set2: 
      !>[A: $tType] : ( ( list @ A ) > ( set @ A ) ) ).

thf(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( A > $o ) > ( list @ A ) > $o ) ).

thf(sy_c_List_Omember,type,
    member: 
      !>[A: $tType] : ( ( list @ A ) > A > $o ) ).

thf(sy_c_List_Osublists,type,
    sublists: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_List_Ounion,type,
    union: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_Misc_Omergesort__remdups,type,
    mergesort_remdups: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( ( set @ A ) > A ) ).

thf(sy_c_Sorted__List__Operations__Mirabelle__fineeiboro_Ointer__sorted,type,
    sorted2037043510sorted: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_member,type,
    member2: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_l1,type,
    l1: list @ a ).

thf(sy_v_l1a____,type,
    l1a: list @ a ).

thf(sy_v_l2,type,
    l2: list @ a ).

thf(sy_v_l2b____,type,
    l2b: list @ a ).

thf(sy_v_x1____,type,
    x1: a ).

thf(sy_v_x2____,type,
    x2: a ).

%----Relevant facts (255)
thf(fact_0_l1__OK,axiom,
    ( ( distinct @ a @ l1 )
    & ( linorder_sorted @ a @ l1 ) ) ).

% l1_OK
thf(fact_1_l2__OK,axiom,
    ( ( distinct @ a @ l2 )
    & ( linorder_sorted @ a @ l2 ) ) ).

% l2_OK
thf(fact_2_x1__l1__props,axiom,
    ( ( distinct @ a @ ( cons @ a @ x1 @ l1a ) )
    & ( linorder_sorted @ a @ ( cons @ a @ x1 @ l1a ) ) ) ).

% x1_l1_props
thf(fact_3_x2__l2__props,axiom,
    ( ( distinct @ a @ ( cons @ a @ x2 @ l2b ) )
    & ( linorder_sorted @ a @ ( cons @ a @ x2 @ l2b ) ) ) ).

% x2_l2_props
thf(fact_4_l1__props,axiom,
    ( ( distinct @ a @ l1a )
    & ( linorder_sorted @ a @ l1a ) ) ).

% l1_props
thf(fact_5_l2__props,axiom,
    ( ( distinct @ a @ l2b )
    & ( linorder_sorted @ a @ l2b ) ) ).

% l2_props
thf(fact_6_x1__nin__l1,axiom,
    ~ ( member2 @ a @ x1 @ ( set2 @ a @ l1a ) ) ).

% x1_nin_l1
thf(fact_7_x2__nin__l2,axiom,
    ~ ( member2 @ a @ x2 @ ( set2 @ a @ l2b ) ) ).

% x2_nin_l2
thf(fact_8_Cons_Ohyps,axiom,
    ( ( ( distinct @ a @ l2b )
      & ( linorder_sorted @ a @ l2b ) )
   => ( ( distinct @ a @ ( sorted2037043510sorted @ a @ ( cons @ a @ x1 @ l1a ) @ l2b ) )
      & ( linorder_sorted @ a @ ( sorted2037043510sorted @ a @ ( cons @ a @ x1 @ l1a ) @ l2b ) )
      & ( ( set2 @ a @ ( sorted2037043510sorted @ a @ ( cons @ a @ x1 @ l1a ) @ l2b ) )
        = ( inf_inf @ ( set @ a ) @ ( set2 @ a @ ( cons @ a @ x1 @ l1a ) ) @ ( set2 @ a @ l2b ) ) ) ) ) ).

% Cons.hyps
thf(fact_9_ind__hyp__l1,axiom,
    ! [L2: list @ a] :
      ( ( ( distinct @ a @ L2 )
        & ( linorder_sorted @ a @ L2 ) )
     => ( ( distinct @ a @ ( sorted2037043510sorted @ a @ l1a @ L2 ) )
        & ( linorder_sorted @ a @ ( sorted2037043510sorted @ a @ l1a @ L2 ) )
        & ( ( set2 @ a @ ( sorted2037043510sorted @ a @ l1a @ L2 ) )
          = ( inf_inf @ ( set @ a ) @ ( set2 @ a @ l1a ) @ ( set2 @ a @ L2 ) ) ) ) ) ).

% ind_hyp_l1
thf(fact_10_ind__hyp__l2,axiom,
    ( ( distinct @ a @ ( sorted2037043510sorted @ a @ ( cons @ a @ x1 @ l1a ) @ l2b ) )
    & ( linorder_sorted @ a @ ( sorted2037043510sorted @ a @ ( cons @ a @ x1 @ l1a ) @ l2b ) )
    & ( ( set2 @ a @ ( sorted2037043510sorted @ a @ ( cons @ a @ x1 @ l1a ) @ l2b ) )
      = ( inf_inf @ ( set @ a ) @ ( set2 @ a @ ( cons @ a @ x1 @ l1a ) ) @ ( set2 @ a @ l2b ) ) ) ) ).

% ind_hyp_l2
thf(fact_11_x2__le,axiom,
    ! [X: a] :
      ( ( member2 @ a @ X @ ( set2 @ a @ l2b ) )
     => ( ord_less_eq @ a @ x2 @ X ) ) ).

% x2_le
thf(fact_12_x1__le,axiom,
    ! [X: a] :
      ( ( member2 @ a @ X @ ( set2 @ a @ l1a ) )
     => ( ord_less_eq @ a @ x1 @ X ) ) ).

% x1_le
thf(fact_13_sorted__distinct__set__unique,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,Ys: list @ A] :
          ( ( linorder_sorted @ A @ Xs )
         => ( ( distinct @ A @ Xs )
           => ( ( linorder_sorted @ A @ Ys )
             => ( ( distinct @ A @ Ys )
               => ( ( ( set2 @ A @ Xs )
                    = ( set2 @ A @ Ys ) )
                 => ( Xs = Ys ) ) ) ) ) ) ) ).

% sorted_distinct_set_unique
thf(fact_14_distinct_Osimps_I2_J,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( distinct @ A @ ( cons @ A @ X @ Xs ) )
      = ( ~ ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
        & ( distinct @ A @ Xs ) ) ) ).

% distinct.simps(2)
thf(fact_15_IntI,axiom,
    ! [A: $tType,C: A,A2: set @ A,B: set @ A] :
      ( ( member2 @ A @ C @ A2 )
     => ( ( member2 @ A @ C @ B )
       => ( member2 @ A @ C @ ( inf_inf @ ( set @ A ) @ A2 @ B ) ) ) ) ).

% IntI
thf(fact_16_Int__iff,axiom,
    ! [A: $tType,C: A,A2: set @ A,B: set @ A] :
      ( ( member2 @ A @ C @ ( inf_inf @ ( set @ A ) @ A2 @ B ) )
      = ( ( member2 @ A @ C @ A2 )
        & ( member2 @ A @ C @ B ) ) ) ).

% Int_iff
thf(fact_17_inf__apply,axiom,
    ! [B2: $tType,A: $tType] :
      ( ( semilattice_inf @ B2 @ ( type2 @ B2 ) )
     => ( ( inf_inf @ ( A > B2 ) )
        = ( ^ [F: A > B2,G: A > B2,X2: A] : ( inf_inf @ B2 @ ( F @ X2 ) @ ( G @ X2 ) ) ) ) ) ).

% inf_apply
thf(fact_18_inf_Oidem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A] :
          ( ( inf_inf @ A @ A3 @ A3 )
          = A3 ) ) ).

% inf.idem
thf(fact_19_inf__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ( ( inf_inf @ A @ X @ X )
          = X ) ) ).

% inf_idem
thf(fact_20_inf_Oleft__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( inf_inf @ A @ A3 @ ( inf_inf @ A @ A3 @ B3 ) )
          = ( inf_inf @ A @ A3 @ B3 ) ) ) ).

% inf.left_idem
thf(fact_21_inf__left__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( inf_inf @ A @ X @ ( inf_inf @ A @ X @ Y ) )
          = ( inf_inf @ A @ X @ Y ) ) ) ).

% inf_left_idem
thf(fact_22_inf_Oright__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ A3 @ B3 ) @ B3 )
          = ( inf_inf @ A @ A3 @ B3 ) ) ) ).

% inf.right_idem
thf(fact_23_list_Oinject,axiom,
    ! [A: $tType,X21: A,X22: list @ A,Y21: A,Y22: list @ A] :
      ( ( ( cons @ A @ X21 @ X22 )
        = ( cons @ A @ Y21 @ Y22 ) )
      = ( ( X21 = Y21 )
        & ( X22 = Y22 ) ) ) ).

% list.inject
thf(fact_24_inf__right__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ X @ Y ) @ Y )
          = ( inf_inf @ A @ X @ Y ) ) ) ).

% inf_right_idem
thf(fact_25_inf_Obounded__iff,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less_eq @ A @ A3 @ ( inf_inf @ A @ B3 @ C ) )
          = ( ( ord_less_eq @ A @ A3 @ B3 )
            & ( ord_less_eq @ A @ A3 @ C ) ) ) ) ).

% inf.bounded_iff
thf(fact_26_le__inf__iff,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( ord_less_eq @ A @ X @ ( inf_inf @ A @ Y @ Z ) )
          = ( ( ord_less_eq @ A @ X @ Y )
            & ( ord_less_eq @ A @ X @ Z ) ) ) ) ).

% le_inf_iff
thf(fact_27_sorted__many__eq,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Zs: list @ A] :
          ( ( linorder_sorted @ A @ ( cons @ A @ X @ ( cons @ A @ Y @ Zs ) ) )
          = ( ( ord_less_eq @ A @ X @ Y )
            & ( linorder_sorted @ A @ ( cons @ A @ Y @ Zs ) ) ) ) ) ).

% sorted_many_eq
thf(fact_28_inf_OcoboundedI2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [B3: A,C: A,A3: A] :
          ( ( ord_less_eq @ A @ B3 @ C )
         => ( ord_less_eq @ A @ ( inf_inf @ A @ A3 @ B3 ) @ C ) ) ) ).

% inf.coboundedI2
thf(fact_29_inf_OcoboundedI1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,C: A,B3: A] :
          ( ( ord_less_eq @ A @ A3 @ C )
         => ( ord_less_eq @ A @ ( inf_inf @ A @ A3 @ B3 ) @ C ) ) ) ).

% inf.coboundedI1
thf(fact_30_inf_Oabsorb__iff2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [B4: A,A4: A] :
              ( ( inf_inf @ A @ A4 @ B4 )
              = B4 ) ) ) ) ).

% inf.absorb_iff2
thf(fact_31_inf_Oabsorb__iff1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [A4: A,B4: A] :
              ( ( inf_inf @ A @ A4 @ B4 )
              = A4 ) ) ) ) ).

% inf.absorb_iff1
thf(fact_32_inf_Ocobounded2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] : ( ord_less_eq @ A @ ( inf_inf @ A @ A3 @ B3 ) @ B3 ) ) ).

% inf.cobounded2
thf(fact_33_inf_Ocobounded1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] : ( ord_less_eq @ A @ ( inf_inf @ A @ A3 @ B3 ) @ A3 ) ) ).

% inf.cobounded1
thf(fact_34_inf_Oorder__iff,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [A4: A,B4: A] :
              ( A4
              = ( inf_inf @ A @ A4 @ B4 ) ) ) ) ) ).

% inf.order_iff
thf(fact_35_inf__greatest,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ X @ Z )
           => ( ord_less_eq @ A @ X @ ( inf_inf @ A @ Y @ Z ) ) ) ) ) ).

% inf_greatest
thf(fact_36_inf_OboundedI,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ A @ A3 @ C )
           => ( ord_less_eq @ A @ A3 @ ( inf_inf @ A @ B3 @ C ) ) ) ) ) ).

% inf.boundedI
thf(fact_37_inf_OboundedE,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less_eq @ A @ A3 @ ( inf_inf @ A @ B3 @ C ) )
         => ~ ( ( ord_less_eq @ A @ A3 @ B3 )
             => ~ ( ord_less_eq @ A @ A3 @ C ) ) ) ) ).

% inf.boundedE
thf(fact_38_inf__absorb2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [Y: A,X: A] :
          ( ( ord_less_eq @ A @ Y @ X )
         => ( ( inf_inf @ A @ X @ Y )
            = Y ) ) ) ).

% inf_absorb2
thf(fact_39_inf__absorb1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( inf_inf @ A @ X @ Y )
            = X ) ) ) ).

% inf_absorb1
thf(fact_40_inf_Oabsorb2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A] :
          ( ( ord_less_eq @ A @ B3 @ A3 )
         => ( ( inf_inf @ A @ A3 @ B3 )
            = B3 ) ) ) ).

% inf.absorb2
thf(fact_41_inf_Oabsorb1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( inf_inf @ A @ A3 @ B3 )
            = A3 ) ) ) ).

% inf.absorb1
thf(fact_42_le__iff__inf,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [X2: A,Y2: A] :
              ( ( inf_inf @ A @ X2 @ Y2 )
              = X2 ) ) ) ) ).

% le_iff_inf
thf(fact_43_inf__unique,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [F2: A > A > A,X: A,Y: A] :
          ( ! [X3: A,Y3: A] : ( ord_less_eq @ A @ ( F2 @ X3 @ Y3 ) @ X3 )
         => ( ! [X3: A,Y3: A] : ( ord_less_eq @ A @ ( F2 @ X3 @ Y3 ) @ Y3 )
           => ( ! [X3: A,Y3: A,Z2: A] :
                  ( ( ord_less_eq @ A @ X3 @ Y3 )
                 => ( ( ord_less_eq @ A @ X3 @ Z2 )
                   => ( ord_less_eq @ A @ X3 @ ( F2 @ Y3 @ Z2 ) ) ) )
             => ( ( inf_inf @ A @ X @ Y )
                = ( F2 @ X @ Y ) ) ) ) ) ) ).

% inf_unique
thf(fact_44_inf_OorderI,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( A3
            = ( inf_inf @ A @ A3 @ B3 ) )
         => ( ord_less_eq @ A @ A3 @ B3 ) ) ) ).

% inf.orderI
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A3: A,P: A > $o] :
      ( ( member2 @ A @ A3 @ ( collect @ A @ P ) )
      = ( P @ A3 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( collect @ A
        @ ^ [X2: A] : ( member2 @ A @ X2 @ A2 ) )
      = A2 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X3: A] :
          ( ( P @ X3 )
          = ( Q @ X3 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B2: $tType,A: $tType,F2: A > B2,G2: A > B2] :
      ( ! [X3: A] :
          ( ( F2 @ X3 )
          = ( G2 @ X3 ) )
     => ( F2 = G2 ) ) ).

% ext
thf(fact_49_inf_OorderE,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( A3
            = ( inf_inf @ A @ A3 @ B3 ) ) ) ) ).

% inf.orderE
thf(fact_50_le__infI2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [B3: A,X: A,A3: A] :
          ( ( ord_less_eq @ A @ B3 @ X )
         => ( ord_less_eq @ A @ ( inf_inf @ A @ A3 @ B3 ) @ X ) ) ) ).

% le_infI2
thf(fact_51_le__infI1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,X: A,B3: A] :
          ( ( ord_less_eq @ A @ A3 @ X )
         => ( ord_less_eq @ A @ ( inf_inf @ A @ A3 @ B3 ) @ X ) ) ) ).

% le_infI1
thf(fact_52_inf__mono,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,C: A,B3: A,D: A] :
          ( ( ord_less_eq @ A @ A3 @ C )
         => ( ( ord_less_eq @ A @ B3 @ D )
           => ( ord_less_eq @ A @ ( inf_inf @ A @ A3 @ B3 ) @ ( inf_inf @ A @ C @ D ) ) ) ) ) ).

% inf_mono
thf(fact_53_le__infI,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,A3: A,B3: A] :
          ( ( ord_less_eq @ A @ X @ A3 )
         => ( ( ord_less_eq @ A @ X @ B3 )
           => ( ord_less_eq @ A @ X @ ( inf_inf @ A @ A3 @ B3 ) ) ) ) ) ).

% le_infI
thf(fact_54_le__infE,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,A3: A,B3: A] :
          ( ( ord_less_eq @ A @ X @ ( inf_inf @ A @ A3 @ B3 ) )
         => ~ ( ( ord_less_eq @ A @ X @ A3 )
             => ~ ( ord_less_eq @ A @ X @ B3 ) ) ) ) ).

% le_infE
thf(fact_55_inf__le2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] : ( ord_less_eq @ A @ ( inf_inf @ A @ X @ Y ) @ Y ) ) ).

% inf_le2
thf(fact_56_inf__le1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] : ( ord_less_eq @ A @ ( inf_inf @ A @ X @ Y ) @ X ) ) ).

% inf_le1
thf(fact_57_inf__sup__ord_I1_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] : ( ord_less_eq @ A @ ( inf_inf @ A @ X @ Y ) @ X ) ) ).

% inf_sup_ord(1)
thf(fact_58_inf__sup__ord_I2_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] : ( ord_less_eq @ A @ ( inf_inf @ A @ X @ Y ) @ Y ) ) ).

% inf_sup_ord(2)
thf(fact_59_sorted__many,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Zs: list @ A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( linorder_sorted @ A @ ( cons @ A @ Y @ Zs ) )
           => ( linorder_sorted @ A @ ( cons @ A @ X @ ( cons @ A @ Y @ Zs ) ) ) ) ) ) ).

% sorted_many
thf(fact_60_sorted__Cons,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Xs: list @ A] :
          ( ( linorder_sorted @ A @ ( cons @ A @ X @ Xs ) )
          = ( ( linorder_sorted @ A @ Xs )
            & ! [X2: A] :
                ( ( member2 @ A @ X2 @ ( set2 @ A @ Xs ) )
               => ( ord_less_eq @ A @ X @ X2 ) ) ) ) ) ).

% sorted_Cons
thf(fact_61_sorted_OCons,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,X: A] :
          ( ! [X3: A] :
              ( ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
             => ( ord_less_eq @ A @ X @ X3 ) )
         => ( ( linorder_sorted @ A @ Xs )
           => ( linorder_sorted @ A @ ( cons @ A @ X @ Xs ) ) ) ) ) ).

% sorted.Cons
thf(fact_62_not__Cons__self2,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( cons @ A @ X @ Xs )
     != Xs ) ).

% not_Cons_self2
thf(fact_63_inf__left__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( inf_inf @ A @ X @ ( inf_inf @ A @ Y @ Z ) )
          = ( inf_inf @ A @ Y @ ( inf_inf @ A @ X @ Z ) ) ) ) ).

% inf_left_commute
thf(fact_64_inf_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A,C: A] :
          ( ( inf_inf @ A @ B3 @ ( inf_inf @ A @ A3 @ C ) )
          = ( inf_inf @ A @ A3 @ ( inf_inf @ A @ B3 @ C ) ) ) ) ).

% inf.left_commute
thf(fact_65_inf__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( inf_inf @ A )
        = ( ^ [X2: A,Y2: A] : ( inf_inf @ A @ Y2 @ X2 ) ) ) ) ).

% inf_commute
thf(fact_66_inf_Ocommute,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( inf_inf @ A )
        = ( ^ [A4: A,B4: A] : ( inf_inf @ A @ B4 @ A4 ) ) ) ) ).

% inf.commute
thf(fact_67_inf__assoc,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ X @ Y ) @ Z )
          = ( inf_inf @ A @ X @ ( inf_inf @ A @ Y @ Z ) ) ) ) ).

% inf_assoc
thf(fact_68_inf_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ A3 @ B3 ) @ C )
          = ( inf_inf @ A @ A3 @ ( inf_inf @ A @ B3 @ C ) ) ) ) ).

% inf.assoc
thf(fact_69_inf__fun__def,axiom,
    ! [B2: $tType,A: $tType] :
      ( ( semilattice_inf @ B2 @ ( type2 @ B2 ) )
     => ( ( inf_inf @ ( A > B2 ) )
        = ( ^ [F: A > B2,G: A > B2,X2: A] : ( inf_inf @ B2 @ ( F @ X2 ) @ ( G @ X2 ) ) ) ) ) ).

% inf_fun_def
thf(fact_70_inf__sup__aci_I1_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ( ( inf_inf @ A )
        = ( ^ [X2: A,Y2: A] : ( inf_inf @ A @ Y2 @ X2 ) ) ) ) ).

% inf_sup_aci(1)
thf(fact_71_inf__sup__aci_I2_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ X @ Y ) @ Z )
          = ( inf_inf @ A @ X @ ( inf_inf @ A @ Y @ Z ) ) ) ) ).

% inf_sup_aci(2)
thf(fact_72_inf__sup__aci_I3_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( inf_inf @ A @ X @ ( inf_inf @ A @ Y @ Z ) )
          = ( inf_inf @ A @ Y @ ( inf_inf @ A @ X @ Z ) ) ) ) ).

% inf_sup_aci(3)
thf(fact_73_inf__sup__aci_I4_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( inf_inf @ A @ X @ ( inf_inf @ A @ X @ Y ) )
          = ( inf_inf @ A @ X @ Y ) ) ) ).

% inf_sup_aci(4)
thf(fact_74_Int__left__commute,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A,C2: set @ A] :
      ( ( inf_inf @ ( set @ A ) @ A2 @ ( inf_inf @ ( set @ A ) @ B @ C2 ) )
      = ( inf_inf @ ( set @ A ) @ B @ ( inf_inf @ ( set @ A ) @ A2 @ C2 ) ) ) ).

% Int_left_commute
thf(fact_75_Int__left__absorb,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] :
      ( ( inf_inf @ ( set @ A ) @ A2 @ ( inf_inf @ ( set @ A ) @ A2 @ B ) )
      = ( inf_inf @ ( set @ A ) @ A2 @ B ) ) ).

% Int_left_absorb
thf(fact_76_Int__commute,axiom,
    ! [A: $tType] :
      ( ( inf_inf @ ( set @ A ) )
      = ( ^ [A5: set @ A,B5: set @ A] : ( inf_inf @ ( set @ A ) @ B5 @ A5 ) ) ) ).

% Int_commute
thf(fact_77_Int__absorb,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( inf_inf @ ( set @ A ) @ A2 @ A2 )
      = A2 ) ).

% Int_absorb
thf(fact_78_Int__assoc,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A,C2: set @ A] :
      ( ( inf_inf @ ( set @ A ) @ ( inf_inf @ ( set @ A ) @ A2 @ B ) @ C2 )
      = ( inf_inf @ ( set @ A ) @ A2 @ ( inf_inf @ ( set @ A ) @ B @ C2 ) ) ) ).

% Int_assoc
thf(fact_79_IntD2,axiom,
    ! [A: $tType,C: A,A2: set @ A,B: set @ A] :
      ( ( member2 @ A @ C @ ( inf_inf @ ( set @ A ) @ A2 @ B ) )
     => ( member2 @ A @ C @ B ) ) ).

% IntD2
thf(fact_80_IntD1,axiom,
    ! [A: $tType,C: A,A2: set @ A,B: set @ A] :
      ( ( member2 @ A @ C @ ( inf_inf @ ( set @ A ) @ A2 @ B ) )
     => ( member2 @ A @ C @ A2 ) ) ).

% IntD1
thf(fact_81_IntE,axiom,
    ! [A: $tType,C: A,A2: set @ A,B: set @ A] :
      ( ( member2 @ A @ C @ ( inf_inf @ ( set @ A ) @ A2 @ B ) )
     => ~ ( ( member2 @ A @ C @ A2 )
         => ~ ( member2 @ A @ C @ B ) ) ) ).

% IntE
thf(fact_82_list_Oset__cases,axiom,
    ! [A: $tType,E: A,A3: list @ A] :
      ( ( member2 @ A @ E @ ( set2 @ A @ A3 ) )
     => ( ! [Z22: list @ A] :
            ( A3
           != ( cons @ A @ E @ Z22 ) )
       => ~ ! [Z1: A,Z22: list @ A] :
              ( ( A3
                = ( cons @ A @ Z1 @ Z22 ) )
             => ~ ( member2 @ A @ E @ ( set2 @ A @ Z22 ) ) ) ) ) ).

% list.set_cases
thf(fact_83_set__ConsD,axiom,
    ! [A: $tType,Y: A,X: A,Xs: list @ A] :
      ( ( member2 @ A @ Y @ ( set2 @ A @ ( cons @ A @ X @ Xs ) ) )
     => ( ( Y = X )
        | ( member2 @ A @ Y @ ( set2 @ A @ Xs ) ) ) ) ).

% set_ConsD
thf(fact_84_list_Oset__intros_I1_J,axiom,
    ! [A: $tType,A1: A,A22: list @ A] : ( member2 @ A @ A1 @ ( set2 @ A @ ( cons @ A @ A1 @ A22 ) ) ) ).

% list.set_intros(1)
thf(fact_85_list_Oset__intros_I2_J,axiom,
    ! [A: $tType,X: A,A22: list @ A,A1: A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ A22 ) )
     => ( member2 @ A @ X @ ( set2 @ A @ ( cons @ A @ A1 @ A22 ) ) ) ) ).

% list.set_intros(2)
thf(fact_86_distinct__length__2__or__more,axiom,
    ! [A: $tType,A3: A,B3: A,Xs: list @ A] :
      ( ( distinct @ A @ ( cons @ A @ A3 @ ( cons @ A @ B3 @ Xs ) ) )
      = ( ( A3 != B3 )
        & ( distinct @ A @ ( cons @ A @ A3 @ Xs ) )
        & ( distinct @ A @ ( cons @ A @ B3 @ Xs ) ) ) ) ).

% distinct_length_2_or_more
thf(fact_87_distinct__union,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( distinct @ A @ ( union @ A @ Xs @ Ys ) )
      = ( distinct @ A @ Ys ) ) ).

% distinct_union
thf(fact_88_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A] : ( ord_less_eq @ A @ X @ X ) ) ).

% order_refl
thf(fact_89_not__in__set__insert,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ~ ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
     => ( ( insert @ A @ X @ Xs )
        = ( cons @ A @ X @ Xs ) ) ) ).

% not_in_set_insert
thf(fact_90_sorted_Oinducts,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: list @ A,P: ( list @ A ) > $o] :
          ( ( linorder_sorted @ A @ X )
         => ( ( P @ ( nil @ A ) )
           => ( ! [Xs2: list @ A,X3: A] :
                  ( ! [Xa: A] :
                      ( ( member2 @ A @ Xa @ ( set2 @ A @ Xs2 ) )
                     => ( ord_less_eq @ A @ X3 @ Xa ) )
                 => ( ( linorder_sorted @ A @ Xs2 )
                   => ( ( P @ Xs2 )
                     => ( P @ ( cons @ A @ X3 @ Xs2 ) ) ) ) )
             => ( P @ X ) ) ) ) ) ).

% sorted.inducts
thf(fact_91_sorted_Osimps,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( ( linorder_sorted @ A )
        = ( ^ [A4: list @ A] :
              ( ( A4
                = ( nil @ A ) )
              | ? [Xs3: list @ A,X2: A] :
                  ( ( A4
                    = ( cons @ A @ X2 @ Xs3 ) )
                  & ! [Y2: A] :
                      ( ( member2 @ A @ Y2 @ ( set2 @ A @ Xs3 ) )
                     => ( ord_less_eq @ A @ X2 @ Y2 ) )
                  & ( linorder_sorted @ A @ Xs3 ) ) ) ) ) ) ).

% sorted.simps
thf(fact_92_sorted_Ocases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A3: list @ A] :
          ( ( linorder_sorted @ A @ A3 )
         => ( ( A3
             != ( nil @ A ) )
           => ~ ! [Xs2: list @ A,X3: A] :
                  ( ( A3
                    = ( cons @ A @ X3 @ Xs2 ) )
                 => ( ! [Xa: A] :
                        ( ( member2 @ A @ Xa @ ( set2 @ A @ Xs2 ) )
                       => ( ord_less_eq @ A @ X3 @ Xa ) )
                   => ~ ( linorder_sorted @ A @ Xs2 ) ) ) ) ) ) ).

% sorted.cases
thf(fact_93_mergesort__remdups__correct,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [L: list @ A] :
          ( ( distinct @ A @ ( mergesort_remdups @ A @ L ) )
          & ( linorder_sorted @ A @ ( mergesort_remdups @ A @ L ) )
          & ( ( set2 @ A @ ( mergesort_remdups @ A @ L ) )
            = ( set2 @ A @ L ) ) ) ) ).

% mergesort_remdups_correct
thf(fact_94_List_Oinsert__def,axiom,
    ! [A: $tType] :
      ( ( insert @ A )
      = ( ^ [X2: A,Xs3: list @ A] : ( if @ ( list @ A ) @ ( member2 @ A @ X2 @ ( set2 @ A @ Xs3 ) ) @ Xs3 @ ( cons @ A @ X2 @ Xs3 ) ) ) ) ).

% List.insert_def
thf(fact_95_in__set__member,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
      = ( member @ A @ Xs @ X ) ) ).

% in_set_member
thf(fact_96_list__tail__coinc,axiom,
    ! [A: $tType,N1: A,R1: list @ A,N2: A,R2: list @ A] :
      ( ( ( cons @ A @ N1 @ R1 )
        = ( cons @ A @ N2 @ R2 ) )
     => ( ( N1 = N2 )
        & ( R1 = R2 ) ) ) ).

% list_tail_coinc
thf(fact_97_Int__subset__iff,axiom,
    ! [A: $tType,C2: set @ A,A2: set @ A,B: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ C2 @ ( inf_inf @ ( set @ A ) @ A2 @ B ) )
      = ( ( ord_less_eq @ ( set @ A ) @ C2 @ A2 )
        & ( ord_less_eq @ ( set @ A ) @ C2 @ B ) ) ) ).

% Int_subset_iff
thf(fact_98_in__set__insert,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
     => ( ( insert @ A @ X @ Xs )
        = Xs ) ) ).

% in_set_insert
thf(fact_99_distinct__insert,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( distinct @ A @ ( insert @ A @ X @ Xs ) )
      = ( distinct @ A @ Xs ) ) ).

% distinct_insert
thf(fact_100_sorted__single,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A] : ( linorder_sorted @ A @ ( cons @ A @ X @ ( nil @ A ) ) ) ) ).

% sorted_single
thf(fact_101_insert__Nil,axiom,
    ! [A: $tType,X: A] :
      ( ( insert @ A @ X @ ( nil @ A ) )
      = ( cons @ A @ X @ ( nil @ A ) ) ) ).

% insert_Nil
thf(fact_102_member__rec_I2_J,axiom,
    ! [A: $tType,Y: A] :
      ~ ( member @ A @ ( nil @ A ) @ Y ) ).

% member_rec(2)
thf(fact_103_transpose_Ocases,axiom,
    ! [A: $tType,X: list @ ( list @ A )] :
      ( ( X
       != ( nil @ ( list @ A ) ) )
     => ( ! [Xss: list @ ( list @ A )] :
            ( X
           != ( cons @ ( list @ A ) @ ( nil @ A ) @ Xss ) )
       => ~ ! [X3: A,Xs2: list @ A,Xss: list @ ( list @ A )] :
              ( X
             != ( cons @ ( list @ A ) @ ( cons @ A @ X3 @ Xs2 ) @ Xss ) ) ) ) ).

% transpose.cases
thf(fact_104_revg_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
      ( ! [X1: list @ A] : ( P @ ( nil @ A ) @ X1 )
     => ( ! [A6: A,As: list @ A,B6: list @ A] :
            ( ( P @ As @ ( cons @ A @ A6 @ B6 ) )
           => ( P @ ( cons @ A @ A6 @ As ) @ B6 ) )
       => ( P @ A0 @ A1 ) ) ) ).

% revg.induct
thf(fact_105_zipf_Oinduct,axiom,
    ! [A: $tType,C3: $tType,B2: $tType,P: ( A > B2 > C3 ) > ( list @ A ) > ( list @ B2 ) > $o,A0: A > B2 > C3,A1: list @ A,A22: list @ B2] :
      ( ! [F3: A > B2 > C3] : ( P @ F3 @ ( nil @ A ) @ ( nil @ B2 ) )
     => ( ! [F3: A > B2 > C3,A6: A,As: list @ A,B6: B2,Bs: list @ B2] :
            ( ( P @ F3 @ As @ Bs )
           => ( P @ F3 @ ( cons @ A @ A6 @ As ) @ ( cons @ B2 @ B6 @ Bs ) ) )
       => ( ! [A6: A > B2 > C3,V: A,Va: list @ A] : ( P @ A6 @ ( cons @ A @ V @ Va ) @ ( nil @ B2 ) )
         => ( ! [A6: A > B2 > C3,V: B2,Va: list @ B2] : ( P @ A6 @ ( nil @ A ) @ ( cons @ B2 @ V @ Va ) )
           => ( P @ A0 @ A1 @ A22 ) ) ) ) ) ).

% zipf.induct
thf(fact_106_list__2pre__induct,axiom,
    ! [A: $tType,B2: $tType,P: ( list @ A ) > ( list @ B2 ) > $o,W1: list @ A,W2: list @ B2] :
      ( ( P @ ( nil @ A ) @ ( nil @ B2 ) )
     => ( ! [E2: A,W12: list @ A,W22: list @ B2] :
            ( ( P @ W12 @ W22 )
           => ( P @ ( cons @ A @ E2 @ W12 ) @ W22 ) )
       => ( ! [E2: B2,W13: list @ A,W23: list @ B2] :
              ( ( P @ W13 @ W23 )
             => ( P @ W13 @ ( cons @ B2 @ E2 @ W23 ) ) )
         => ( P @ W1 @ W2 ) ) ) ) ).

% list_2pre_induct
thf(fact_107_list__induct__first2,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,Xs: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X3: A] : ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X1: A,X23: A,Xs2: list @ A] :
              ( ( P @ Xs2 )
             => ( P @ ( cons @ A @ X1 @ ( cons @ A @ X23 @ Xs2 ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% list_induct_first2
thf(fact_108_list__all__zip_Oinduct,axiom,
    ! [A: $tType,B2: $tType,P: ( A > B2 > $o ) > ( list @ A ) > ( list @ B2 ) > $o,A0: A > B2 > $o,A1: list @ A,A22: list @ B2] :
      ( ! [P2: A > B2 > $o] : ( P @ P2 @ ( nil @ A ) @ ( nil @ B2 ) )
     => ( ! [P2: A > B2 > $o,A6: A,As: list @ A,B6: B2,Bs: list @ B2] :
            ( ( P @ P2 @ As @ Bs )
           => ( P @ P2 @ ( cons @ A @ A6 @ As ) @ ( cons @ B2 @ B6 @ Bs ) ) )
       => ( ! [P2: A > B2 > $o,V: A,Va: list @ A] : ( P @ P2 @ ( cons @ A @ V @ Va ) @ ( nil @ B2 ) )
         => ( ! [P2: A > B2 > $o,V: B2,Va: list @ B2] : ( P @ P2 @ ( nil @ A ) @ ( cons @ B2 @ V @ Va ) )
           => ( P @ A0 @ A1 @ A22 ) ) ) ) ) ).

% list_all_zip.induct
thf(fact_109_mergesort__by__rel__merge_Oinduct,axiom,
    ! [A: $tType,P: ( A > A > $o ) > ( list @ A ) > ( list @ A ) > $o,A0: A > A > $o,A1: list @ A,A22: list @ A] :
      ( ! [R: A > A > $o,X3: A,Xs2: list @ A,Y3: A,Ys2: list @ A] :
          ( ( ( R @ X3 @ Y3 )
           => ( P @ R @ Xs2 @ ( cons @ A @ Y3 @ Ys2 ) ) )
         => ( ( ~ ( R @ X3 @ Y3 )
             => ( P @ R @ ( cons @ A @ X3 @ Xs2 ) @ Ys2 ) )
           => ( P @ R @ ( cons @ A @ X3 @ Xs2 ) @ ( cons @ A @ Y3 @ Ys2 ) ) ) )
     => ( ! [R: A > A > $o,Xs2: list @ A] : ( P @ R @ Xs2 @ ( nil @ A ) )
       => ( ! [R: A > A > $o,V: A,Va: list @ A] : ( P @ R @ ( nil @ A ) @ ( cons @ A @ V @ Va ) )
         => ( P @ A0 @ A1 @ A22 ) ) ) ) ).

% mergesort_by_rel_merge.induct
thf(fact_110_mergesort__by__rel__merge__induct,axiom,
    ! [A: $tType,B2: $tType,P: ( list @ A ) > ( list @ B2 ) > $o,R3: A > B2 > $o,Xs: list @ A,Ys: list @ B2] :
      ( ! [Xs2: list @ A] : ( P @ Xs2 @ ( nil @ B2 ) )
     => ( ! [X1: list @ B2] : ( P @ ( nil @ A ) @ X1 )
       => ( ! [X3: A,Xs2: list @ A,Y3: B2,Ys2: list @ B2] :
              ( ( R3 @ X3 @ Y3 )
             => ( ( P @ Xs2 @ ( cons @ B2 @ Y3 @ Ys2 ) )
               => ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( cons @ B2 @ Y3 @ Ys2 ) ) ) )
         => ( ! [X3: A,Xs2: list @ A,Y3: B2,Ys2: list @ B2] :
                ( ~ ( R3 @ X3 @ Y3 )
               => ( ( P @ ( cons @ A @ X3 @ Xs2 ) @ Ys2 )
                 => ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( cons @ B2 @ Y3 @ Ys2 ) ) ) )
           => ( P @ Xs @ Ys ) ) ) ) ) ).

% mergesort_by_rel_merge_induct
thf(fact_111_inter__eq__subsetI,axiom,
    ! [A: $tType,S: set @ A,S2: set @ A,A2: set @ A,B: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ S @ S2 )
     => ( ( ( inf_inf @ ( set @ A ) @ A2 @ S2 )
          = ( inf_inf @ ( set @ A ) @ B @ S2 ) )
       => ( ( inf_inf @ ( set @ A ) @ A2 @ S )
          = ( inf_inf @ ( set @ A ) @ B @ S ) ) ) ) ).

% inter_eq_subsetI
thf(fact_112_subset__code_I1_J,axiom,
    ! [A: $tType,Xs: list @ A,B: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ Xs ) @ B )
      = ( ! [X2: A] :
            ( ( member2 @ A @ X2 @ ( set2 @ A @ Xs ) )
           => ( member2 @ A @ X2 @ B ) ) ) ) ).

% subset_code(1)
thf(fact_113_list_Odistinct_I1_J,axiom,
    ! [A: $tType,X21: A,X22: list @ A] :
      ( ( nil @ A )
     != ( cons @ A @ X21 @ X22 ) ) ).

% list.distinct(1)
thf(fact_114_list_OdiscI,axiom,
    ! [A: $tType,List: list @ A,X21: A,X22: list @ A] :
      ( ( List
        = ( cons @ A @ X21 @ X22 ) )
     => ( List
       != ( nil @ A ) ) ) ).

% list.discI
thf(fact_115_list_Oexhaust,axiom,
    ! [A: $tType,Y: list @ A] :
      ( ( Y
       != ( nil @ A ) )
     => ~ ! [X212: A,X222: list @ A] :
            ( Y
           != ( cons @ A @ X212 @ X222 ) ) ) ).

% list.exhaust
thf(fact_116_list_Oinducts,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,List: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X1: A,X23: list @ A] :
            ( ( P @ X23 )
           => ( P @ ( cons @ A @ X1 @ X23 ) ) )
       => ( P @ List ) ) ) ).

% list.inducts
thf(fact_117_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
      = ( ? [Y2: A,Ys3: list @ A] :
            ( Xs
            = ( cons @ A @ Y2 @ Ys3 ) ) ) ) ).

% neq_Nil_conv
thf(fact_118_list__induct2_H,axiom,
    ! [A: $tType,B2: $tType,P: ( list @ A ) > ( list @ B2 ) > $o,Xs: list @ A,Ys: list @ B2] :
      ( ( P @ ( nil @ A ) @ ( nil @ B2 ) )
     => ( ! [X3: A,Xs2: list @ A] : ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( nil @ B2 ) )
       => ( ! [Y3: B2,Ys2: list @ B2] : ( P @ ( nil @ A ) @ ( cons @ B2 @ Y3 @ Ys2 ) )
         => ( ! [X3: A,Xs2: list @ A,Y3: B2,Ys2: list @ B2] :
                ( ( P @ Xs2 @ Ys2 )
               => ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( cons @ B2 @ Y3 @ Ys2 ) ) )
           => ( P @ Xs @ Ys ) ) ) ) ) ).

% list_induct2'
thf(fact_119_splice_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
      ( ! [X1: list @ A] : ( P @ ( nil @ A ) @ X1 )
     => ( ! [V: A,Va: list @ A] : ( P @ ( cons @ A @ V @ Va ) @ ( nil @ A ) )
       => ( ! [X3: A,Xs2: list @ A,Y3: A,Ys2: list @ A] :
              ( ( P @ Xs2 @ Ys2 )
             => ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( cons @ A @ Y3 @ Ys2 ) ) )
         => ( P @ A0 @ A1 ) ) ) ) ).

% splice.induct
thf(fact_120_remdups__adj_Ocases,axiom,
    ! [A: $tType,X: list @ A] :
      ( ( X
       != ( nil @ A ) )
     => ( ! [X3: A] :
            ( X
           != ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ~ ! [X3: A,Y3: A,Xs2: list @ A] :
              ( X
             != ( cons @ A @ X3 @ ( cons @ A @ Y3 @ Xs2 ) ) ) ) ) ).

% remdups_adj.cases
thf(fact_121_remdups__adj_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,A0: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X3: A] : ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X3: A,Y3: A,Xs2: list @ A] :
              ( ( ( X3 = Y3 )
               => ( P @ ( cons @ A @ X3 @ Xs2 ) ) )
             => ( ( ( X3 != Y3 )
                 => ( P @ ( cons @ A @ Y3 @ Xs2 ) ) )
               => ( P @ ( cons @ A @ X3 @ ( cons @ A @ Y3 @ Xs2 ) ) ) ) )
         => ( P @ A0 ) ) ) ) ).

% remdups_adj.induct
thf(fact_122_list__nonempty__induct,axiom,
    ! [A: $tType,Xs: list @ A,P: ( list @ A ) > $o] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ! [X3: A] : ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X3: A,Xs2: list @ A] :
              ( ( Xs2
               != ( nil @ A ) )
             => ( ( P @ Xs2 )
               => ( P @ ( cons @ A @ X3 @ Xs2 ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% list_nonempty_induct
thf(fact_123_map__tailrec__rev_Oinduct,axiom,
    ! [A: $tType,B2: $tType,P: ( A > B2 ) > ( list @ A ) > ( list @ B2 ) > $o,A0: A > B2,A1: list @ A,A22: list @ B2] :
      ( ! [F3: A > B2,X1: list @ B2] : ( P @ F3 @ ( nil @ A ) @ X1 )
     => ( ! [F3: A > B2,A6: A,As: list @ A,Bs: list @ B2] :
            ( ( P @ F3 @ As @ ( cons @ B2 @ ( F3 @ A6 ) @ Bs ) )
           => ( P @ F3 @ ( cons @ A @ A6 @ As ) @ Bs ) )
       => ( P @ A0 @ A1 @ A22 ) ) ) ).

% map_tailrec_rev.induct
thf(fact_124_Int__mono,axiom,
    ! [A: $tType,A2: set @ A,C2: set @ A,B: set @ A,D2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ C2 )
     => ( ( ord_less_eq @ ( set @ A ) @ B @ D2 )
       => ( ord_less_eq @ ( set @ A ) @ ( inf_inf @ ( set @ A ) @ A2 @ B ) @ ( inf_inf @ ( set @ A ) @ C2 @ D2 ) ) ) ) ).

% Int_mono
thf(fact_125_Int__lower1,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] : ( ord_less_eq @ ( set @ A ) @ ( inf_inf @ ( set @ A ) @ A2 @ B ) @ A2 ) ).

% Int_lower1
thf(fact_126_Int__lower2,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] : ( ord_less_eq @ ( set @ A ) @ ( inf_inf @ ( set @ A ) @ A2 @ B ) @ B ) ).

% Int_lower2
thf(fact_127_Int__absorb1,axiom,
    ! [A: $tType,B: set @ A,A2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ B @ A2 )
     => ( ( inf_inf @ ( set @ A ) @ A2 @ B )
        = B ) ) ).

% Int_absorb1
thf(fact_128_Int__absorb2,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
     => ( ( inf_inf @ ( set @ A ) @ A2 @ B )
        = A2 ) ) ).

% Int_absorb2
thf(fact_129_Int__greatest,axiom,
    ! [A: $tType,C2: set @ A,A2: set @ A,B: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ C2 @ A2 )
     => ( ( ord_less_eq @ ( set @ A ) @ C2 @ B )
       => ( ord_less_eq @ ( set @ A ) @ C2 @ ( inf_inf @ ( set @ A ) @ A2 @ B ) ) ) ) ).

% Int_greatest
thf(fact_130_Int__Collect__mono,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A,P: A > $o,Q: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
     => ( ! [X3: A] :
            ( ( member2 @ A @ X3 @ A2 )
           => ( ( P @ X3 )
             => ( Q @ X3 ) ) )
       => ( ord_less_eq @ ( set @ A ) @ ( inf_inf @ ( set @ A ) @ A2 @ ( collect @ A @ P ) ) @ ( inf_inf @ ( set @ A ) @ B @ ( collect @ A @ Q ) ) ) ) ) ).

% Int_Collect_mono
thf(fact_131_distinct_Osimps_I1_J,axiom,
    ! [A: $tType] : ( distinct @ A @ ( nil @ A ) ) ).

% distinct.simps(1)
thf(fact_132_sorted_ONil,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( linorder_sorted @ A @ ( nil @ A ) ) ) ).

% sorted.Nil
thf(fact_133_inter__sorted_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [L2: list @ A] :
          ( ( sorted2037043510sorted @ A @ ( nil @ A ) @ L2 )
          = ( nil @ A ) ) ) ).

% inter_sorted.simps(1)
thf(fact_134_set__subset__Cons,axiom,
    ! [A: $tType,Xs: list @ A,X: A] : ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ Xs ) @ ( set2 @ A @ ( cons @ A @ X @ Xs ) ) ) ).

% set_subset_Cons
thf(fact_135_distinct__singleton,axiom,
    ! [A: $tType,X: A] : ( distinct @ A @ ( cons @ A @ X @ ( nil @ A ) ) ) ).

% distinct_singleton
thf(fact_136_inter__sorted_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [V2: A,Va2: list @ A] :
          ( ( sorted2037043510sorted @ A @ ( cons @ A @ V2 @ Va2 ) @ ( nil @ A ) )
          = ( nil @ A ) ) ) ).

% inter_sorted.simps(2)
thf(fact_137_dual__order_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A] :
          ( ( ord_less_eq @ A @ B3 @ A3 )
         => ( ( ord_less_eq @ A @ A3 @ B3 )
           => ( A3 = B3 ) ) ) ) ).

% dual_order.antisym
thf(fact_138_dual__order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A,C: A] :
          ( ( ord_less_eq @ A @ B3 @ A3 )
         => ( ( ord_less_eq @ A @ C @ B3 )
           => ( ord_less_eq @ A @ C @ A3 ) ) ) ) ).

% dual_order.trans
thf(fact_139_linorder__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > A > $o,A3: A,B3: A] :
          ( ! [A6: A,B6: A] :
              ( ( ord_less_eq @ A @ A6 @ B6 )
             => ( P @ A6 @ B6 ) )
         => ( ! [A6: A,B6: A] :
                ( ( P @ B6 @ A6 )
               => ( P @ A6 @ B6 ) )
           => ( P @ A3 @ B3 ) ) ) ) ).

% linorder_wlog
thf(fact_140_dual__order_Orefl,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A] : ( ord_less_eq @ A @ A3 @ A3 ) ) ).

% dual_order.refl
thf(fact_141_order__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ Y @ Z )
           => ( ord_less_eq @ A @ X @ Z ) ) ) ) ).

% order_trans
thf(fact_142_order__class_Oorder_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ A @ B3 @ A3 )
           => ( A3 = B3 ) ) ) ) ).

% order_class.order.antisym
thf(fact_143_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( B3 = C )
           => ( ord_less_eq @ A @ A3 @ C ) ) ) ) ).

% ord_le_eq_trans
thf(fact_144_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( A3 = B3 )
         => ( ( ord_less_eq @ A @ B3 @ C )
           => ( ord_less_eq @ A @ A3 @ C ) ) ) ) ).

% ord_eq_le_trans
thf(fact_145_antisym__conv,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [Y: A,X: A] :
          ( ( ord_less_eq @ A @ Y @ X )
         => ( ( ord_less_eq @ A @ X @ Y )
            = ( X = Y ) ) ) ) ).

% antisym_conv
thf(fact_146_le__cases3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( ( ord_less_eq @ A @ X @ Y )
           => ~ ( ord_less_eq @ A @ Y @ Z ) )
         => ( ( ( ord_less_eq @ A @ Y @ X )
             => ~ ( ord_less_eq @ A @ X @ Z ) )
           => ( ( ( ord_less_eq @ A @ X @ Z )
               => ~ ( ord_less_eq @ A @ Z @ Y ) )
             => ( ( ( ord_less_eq @ A @ Z @ Y )
                 => ~ ( ord_less_eq @ A @ Y @ X ) )
               => ( ( ( ord_less_eq @ A @ Y @ Z )
                   => ~ ( ord_less_eq @ A @ Z @ X ) )
                 => ~ ( ( ord_less_eq @ A @ Z @ X )
                     => ~ ( ord_less_eq @ A @ X @ Y ) ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_147_order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ A @ B3 @ C )
           => ( ord_less_eq @ A @ A3 @ C ) ) ) ) ).

% order.trans
thf(fact_148_le__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ~ ( ord_less_eq @ A @ X @ Y )
         => ( ord_less_eq @ A @ Y @ X ) ) ) ).

% le_cases
thf(fact_149_eq__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( X = Y )
         => ( ord_less_eq @ A @ X @ Y ) ) ) ).

% eq_refl
thf(fact_150_linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
          | ( ord_less_eq @ A @ Y @ X ) ) ) ).

% linear
thf(fact_151_antisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ Y @ X )
           => ( X = Y ) ) ) ) ).

% antisym
thf(fact_152_eq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ^ [Y4: A,Z3: A] : ( Y4 = Z3 ) )
        = ( ^ [X2: A,Y2: A] :
              ( ( ord_less_eq @ A @ X2 @ Y2 )
              & ( ord_less_eq @ A @ Y2 @ X2 ) ) ) ) ) ).

% eq_iff
thf(fact_153_ord__le__eq__subst,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ( ord @ B2 @ ( type2 @ B2 ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A3: A,B3: A,F2: A > B2,C: B2] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ( F2 @ B3 )
              = C )
           => ( ! [X3: A,Y3: A] :
                  ( ( ord_less_eq @ A @ X3 @ Y3 )
                 => ( ord_less_eq @ B2 @ ( F2 @ X3 ) @ ( F2 @ Y3 ) ) )
             => ( ord_less_eq @ B2 @ ( F2 @ A3 ) @ C ) ) ) ) ) ).

% ord_le_eq_subst
thf(fact_154_ord__eq__le__subst,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ( ord @ B2 @ ( type2 @ B2 ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A3: A,F2: B2 > A,B3: B2,C: B2] :
          ( ( A3
            = ( F2 @ B3 ) )
         => ( ( ord_less_eq @ B2 @ B3 @ C )
           => ( ! [X3: B2,Y3: B2] :
                  ( ( ord_less_eq @ B2 @ X3 @ Y3 )
                 => ( ord_less_eq @ A @ ( F2 @ X3 ) @ ( F2 @ Y3 ) ) )
             => ( ord_less_eq @ A @ A3 @ ( F2 @ C ) ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_155_ord__eq__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A,D: A] :
          ( ( A3 = B3 )
         => ( ( ord_less_eq @ A @ B3 @ C )
           => ( ( C = D )
             => ( ord_less_eq @ A @ A3 @ D ) ) ) ) ) ).

% ord_eq_le_eq_trans
thf(fact_156_order__subst2,axiom,
    ! [A: $tType,C3: $tType] :
      ( ( ( order @ C3 @ ( type2 @ C3 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A3: A,B3: A,F2: A > C3,C: C3] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ C3 @ ( F2 @ B3 ) @ C )
           => ( ! [X3: A,Y3: A] :
                  ( ( ord_less_eq @ A @ X3 @ Y3 )
                 => ( ord_less_eq @ C3 @ ( F2 @ X3 ) @ ( F2 @ Y3 ) ) )
             => ( ord_less_eq @ C3 @ ( F2 @ A3 ) @ C ) ) ) ) ) ).

% order_subst2
thf(fact_157_order__subst1,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ( order @ B2 @ ( type2 @ B2 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A3: A,F2: B2 > A,B3: B2,C: B2] :
          ( ( ord_less_eq @ A @ A3 @ ( F2 @ B3 ) )
         => ( ( ord_less_eq @ B2 @ B3 @ C )
           => ( ! [X3: B2,Y3: B2] :
                  ( ( ord_less_eq @ B2 @ X3 @ Y3 )
                 => ( ord_less_eq @ A @ ( F2 @ X3 ) @ ( F2 @ Y3 ) ) )
             => ( ord_less_eq @ A @ A3 @ ( F2 @ C ) ) ) ) ) ) ).

% order_subst1
thf(fact_158_le__fun__def,axiom,
    ! [B2: $tType,A: $tType] :
      ( ( ord @ B2 @ ( type2 @ B2 ) )
     => ( ( ord_less_eq @ ( A > B2 ) )
        = ( ^ [F: A > B2,G: A > B2] :
            ! [X2: A] : ( ord_less_eq @ B2 @ ( F @ X2 ) @ ( G @ X2 ) ) ) ) ) ).

% le_fun_def
thf(fact_159_le__funI,axiom,
    ! [B2: $tType,A: $tType] :
      ( ( ord @ B2 @ ( type2 @ B2 ) )
     => ! [F2: A > B2,G2: A > B2] :
          ( ! [X3: A] : ( ord_less_eq @ B2 @ ( F2 @ X3 ) @ ( G2 @ X3 ) )
         => ( ord_less_eq @ ( A > B2 ) @ F2 @ G2 ) ) ) ).

% le_funI
thf(fact_160_le__funE,axiom,
    ! [B2: $tType,A: $tType] :
      ( ( ord @ B2 @ ( type2 @ B2 ) )
     => ! [F2: A > B2,G2: A > B2,X: A] :
          ( ( ord_less_eq @ ( A > B2 ) @ F2 @ G2 )
         => ( ord_less_eq @ B2 @ ( F2 @ X ) @ ( G2 @ X ) ) ) ) ).

% le_funE
thf(fact_161_le__funD,axiom,
    ! [B2: $tType,A: $tType] :
      ( ( ord @ B2 @ ( type2 @ B2 ) )
     => ! [F2: A > B2,G2: A > B2,X: A] :
          ( ( ord_less_eq @ ( A > B2 ) @ F2 @ G2 )
         => ( ord_less_eq @ B2 @ ( F2 @ X ) @ ( G2 @ X ) ) ) ) ).

% le_funD
thf(fact_162_member__rec_I1_J,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Y: A] :
      ( ( member @ A @ ( cons @ A @ X @ Xs ) @ Y )
      = ( ( X = Y )
        | ( member @ A @ Xs @ Y ) ) ) ).

% member_rec(1)
thf(fact_163_the__elem__set,axiom,
    ! [A: $tType,X: A] :
      ( ( the_elem @ A @ ( set2 @ A @ ( cons @ A @ X @ ( nil @ A ) ) ) )
      = X ) ).

% the_elem_set
thf(fact_164_quicksort_Ocases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: list @ A] :
          ( ( X
           != ( nil @ A ) )
         => ~ ! [X3: A,Xs2: list @ A] :
                ( X
               != ( cons @ A @ X3 @ Xs2 ) ) ) ) ).

% quicksort.cases
thf(fact_165_sorted__append__bigger,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,Y: A] :
          ( ( linorder_sorted @ A @ Xs )
         => ( ! [X3: A] :
                ( ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
               => ( ord_less_eq @ A @ X3 @ Y ) )
           => ( linorder_sorted @ A @ ( append @ A @ Xs @ ( cons @ A @ Y @ ( nil @ A ) ) ) ) ) ) ) ).

% sorted_append_bigger
thf(fact_166_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P: A > $o] :
      ~ ( list_ex1 @ A @ P @ ( nil @ A ) ) ).

% list_ex1_simps(1)
thf(fact_167_sorted__hd__min,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A] :
          ( ( Xs
           != ( nil @ A ) )
         => ( ( linorder_sorted @ A @ Xs )
           => ! [X4: A] :
                ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
               => ( ord_less_eq @ A @ ( hd @ A @ Xs ) @ X4 ) ) ) ) ) ).

% sorted_hd_min
thf(fact_168_subsetI,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] :
      ( ! [X3: A] :
          ( ( member2 @ A @ X3 @ A2 )
         => ( member2 @ A @ X3 @ B ) )
     => ( ord_less_eq @ ( set @ A ) @ A2 @ B ) ) ).

% subsetI
thf(fact_169_subset__antisym,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
     => ( ( ord_less_eq @ ( set @ A ) @ B @ A2 )
       => ( A2 = B ) ) ) ).

% subset_antisym
thf(fact_170_same__append__eq,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,Zs: list @ A] :
      ( ( ( append @ A @ Xs @ Ys )
        = ( append @ A @ Xs @ Zs ) )
      = ( Ys = Zs ) ) ).

% same_append_eq
thf(fact_171_append__same__eq,axiom,
    ! [A: $tType,Ys: list @ A,Xs: list @ A,Zs: list @ A] :
      ( ( ( append @ A @ Ys @ Xs )
        = ( append @ A @ Zs @ Xs ) )
      = ( Ys = Zs ) ) ).

% append_same_eq
thf(fact_172_append__assoc,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,Zs: list @ A] :
      ( ( append @ A @ ( append @ A @ Xs @ Ys ) @ Zs )
      = ( append @ A @ Xs @ ( append @ A @ Ys @ Zs ) ) ) ).

% append_assoc
thf(fact_173_append__is__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( append @ A @ Xs @ Ys )
        = ( nil @ A ) )
      = ( ( Xs
          = ( nil @ A ) )
        & ( Ys
          = ( nil @ A ) ) ) ) ).

% append_is_Nil_conv
thf(fact_174_Nil__is__append__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( nil @ A )
        = ( append @ A @ Xs @ Ys ) )
      = ( ( Xs
          = ( nil @ A ) )
        & ( Ys
          = ( nil @ A ) ) ) ) ).

% Nil_is_append_conv
thf(fact_175_self__append__conv2,axiom,
    ! [A: $tType,Ys: list @ A,Xs: list @ A] :
      ( ( Ys
        = ( append @ A @ Xs @ Ys ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% self_append_conv2
thf(fact_176_append__self__conv2,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( append @ A @ Xs @ Ys )
        = Ys )
      = ( Xs
        = ( nil @ A ) ) ) ).

% append_self_conv2
thf(fact_177_self__append__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( Xs
        = ( append @ A @ Xs @ Ys ) )
      = ( Ys
        = ( nil @ A ) ) ) ).

% self_append_conv
thf(fact_178_append__self__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( append @ A @ Xs @ Ys )
        = Xs )
      = ( Ys
        = ( nil @ A ) ) ) ).

% append_self_conv
thf(fact_179_append__Nil2,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( append @ A @ Xs @ ( nil @ A ) )
      = Xs ) ).

% append_Nil2
thf(fact_180_append1__eq__conv,axiom,
    ! [A: $tType,Xs: list @ A,X: A,Ys: list @ A,Y: A] :
      ( ( ( append @ A @ Xs @ ( cons @ A @ X @ ( nil @ A ) ) )
        = ( append @ A @ Ys @ ( cons @ A @ Y @ ( nil @ A ) ) ) )
      = ( ( Xs = Ys )
        & ( X = Y ) ) ) ).

% append1_eq_conv
thf(fact_181_list__ee__eq__leel_I1_J,axiom,
    ! [A: $tType,E1: A,E22: A,L1: list @ A,E12: A,E23: A,L2: list @ A] :
      ( ( ( cons @ A @ E1 @ ( cons @ A @ E22 @ ( nil @ A ) ) )
        = ( append @ A @ L1 @ ( cons @ A @ E12 @ ( cons @ A @ E23 @ L2 ) ) ) )
      = ( ( L1
          = ( nil @ A ) )
        & ( E1 = E12 )
        & ( E22 = E23 )
        & ( L2
          = ( nil @ A ) ) ) ) ).

% list_ee_eq_leel(1)
thf(fact_182_list__ee__eq__leel_I2_J,axiom,
    ! [A: $tType,L1: list @ A,E12: A,E23: A,L2: list @ A,E1: A,E22: A] :
      ( ( ( append @ A @ L1 @ ( cons @ A @ E12 @ ( cons @ A @ E23 @ L2 ) ) )
        = ( cons @ A @ E1 @ ( cons @ A @ E22 @ ( nil @ A ) ) ) )
      = ( ( L1
          = ( nil @ A ) )
        & ( E1 = E12 )
        & ( E22 = E23 )
        & ( L2
          = ( nil @ A ) ) ) ) ).

% list_ee_eq_leel(2)
thf(fact_183_list__se__match_I1_J,axiom,
    ! [A: $tType,L1: list @ A,L2: list @ A,A3: A] :
      ( ( L1
       != ( nil @ A ) )
     => ( ( ( append @ A @ L1 @ L2 )
          = ( cons @ A @ A3 @ ( nil @ A ) ) )
        = ( ( L1
            = ( cons @ A @ A3 @ ( nil @ A ) ) )
          & ( L2
            = ( nil @ A ) ) ) ) ) ).

% list_se_match(1)
thf(fact_184_list__se__match_I2_J,axiom,
    ! [A: $tType,L2: list @ A,L1: list @ A,A3: A] :
      ( ( L2
       != ( nil @ A ) )
     => ( ( ( append @ A @ L1 @ L2 )
          = ( cons @ A @ A3 @ ( nil @ A ) ) )
        = ( ( L1
            = ( nil @ A ) )
          & ( L2
            = ( cons @ A @ A3 @ ( nil @ A ) ) ) ) ) ) ).

% list_se_match(2)
thf(fact_185_list__se__match_I3_J,axiom,
    ! [A: $tType,L1: list @ A,A3: A,L2: list @ A] :
      ( ( L1
       != ( nil @ A ) )
     => ( ( ( cons @ A @ A3 @ ( nil @ A ) )
          = ( append @ A @ L1 @ L2 ) )
        = ( ( L1
            = ( cons @ A @ A3 @ ( nil @ A ) ) )
          & ( L2
            = ( nil @ A ) ) ) ) ) ).

% list_se_match(3)
thf(fact_186_list__se__match_I4_J,axiom,
    ! [A: $tType,L2: list @ A,A3: A,L1: list @ A] :
      ( ( L2
       != ( nil @ A ) )
     => ( ( ( cons @ A @ A3 @ ( nil @ A ) )
          = ( append @ A @ L1 @ L2 ) )
        = ( ( L1
            = ( nil @ A ) )
          & ( L2
            = ( cons @ A @ A3 @ ( nil @ A ) ) ) ) ) ) ).

% list_se_match(4)
thf(fact_187_list__e__eq__lel_I1_J,axiom,
    ! [A: $tType,E: A,L1: list @ A,E3: A,L2: list @ A] :
      ( ( ( cons @ A @ E @ ( nil @ A ) )
        = ( append @ A @ L1 @ ( cons @ A @ E3 @ L2 ) ) )
      = ( ( L1
          = ( nil @ A ) )
        & ( E3 = E )
        & ( L2
          = ( nil @ A ) ) ) ) ).

% list_e_eq_lel(1)
thf(fact_188_list__e__eq__lel_I2_J,axiom,
    ! [A: $tType,L1: list @ A,E3: A,L2: list @ A,E: A] :
      ( ( ( append @ A @ L1 @ ( cons @ A @ E3 @ L2 ) )
        = ( cons @ A @ E @ ( nil @ A ) ) )
      = ( ( L1
          = ( nil @ A ) )
        & ( E3 = E )
        & ( L2
          = ( nil @ A ) ) ) ) ).

% list_e_eq_lel(2)
thf(fact_189_hd__append2,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( hd @ A @ ( append @ A @ Xs @ Ys ) )
        = ( hd @ A @ Xs ) ) ) ).

% hd_append2
thf(fact_190_set__mp,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A,X: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
     => ( ( member2 @ A @ X @ A2 )
       => ( member2 @ A @ X @ B ) ) ) ).

% set_mp
thf(fact_191_in__mono,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A,X: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
     => ( ( member2 @ A @ X @ A2 )
       => ( member2 @ A @ X @ B ) ) ) ).

% in_mono
thf(fact_192_subsetD,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A,C: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
     => ( ( member2 @ A @ C @ A2 )
       => ( member2 @ A @ C @ B ) ) ) ).

% subsetD
thf(fact_193_subsetCE,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A,C: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
     => ( ( member2 @ A @ C @ A2 )
       => ( member2 @ A @ C @ B ) ) ) ).

% subsetCE
thf(fact_194_equalityE,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] :
      ( ( A2 = B )
     => ~ ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
         => ~ ( ord_less_eq @ ( set @ A ) @ B @ A2 ) ) ) ).

% equalityE
thf(fact_195_subset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A5: set @ A,B5: set @ A] :
          ! [X2: A] :
            ( ( member2 @ A @ X2 @ A5 )
           => ( member2 @ A @ X2 @ B5 ) ) ) ) ).

% subset_eq
thf(fact_196_hd__append,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( Xs
          = ( nil @ A ) )
       => ( ( hd @ A @ ( append @ A @ Xs @ Ys ) )
          = ( hd @ A @ Ys ) ) )
      & ( ( Xs
         != ( nil @ A ) )
       => ( ( hd @ A @ ( append @ A @ Xs @ Ys ) )
          = ( hd @ A @ Xs ) ) ) ) ).

% hd_append
thf(fact_197_equalityD1,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] :
      ( ( A2 = B )
     => ( ord_less_eq @ ( set @ A ) @ A2 @ B ) ) ).

% equalityD1
thf(fact_198_equalityD2,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] :
      ( ( A2 = B )
     => ( ord_less_eq @ ( set @ A ) @ B @ A2 ) ) ).

% equalityD2
thf(fact_199_set__rev__mp,axiom,
    ! [A: $tType,X: A,A2: set @ A,B: set @ A] :
      ( ( member2 @ A @ X @ A2 )
     => ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
       => ( member2 @ A @ X @ B ) ) ) ).

% set_rev_mp
thf(fact_200_subset__iff,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A5: set @ A,B5: set @ A] :
          ! [T: A] :
            ( ( member2 @ A @ T @ A5 )
           => ( member2 @ A @ T @ B5 ) ) ) ) ).

% subset_iff
thf(fact_201_rev__subsetD,axiom,
    ! [A: $tType,C: A,A2: set @ A,B: set @ A] :
      ( ( member2 @ A @ C @ A2 )
     => ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
       => ( member2 @ A @ C @ B ) ) ) ).

% rev_subsetD
thf(fact_202_subset__refl,axiom,
    ! [A: $tType,A2: set @ A] : ( ord_less_eq @ ( set @ A ) @ A2 @ A2 ) ).

% subset_refl
thf(fact_203_Collect__mono,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X3: A] :
          ( ( P @ X3 )
         => ( Q @ X3 ) )
     => ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) ) ) ).

% Collect_mono
thf(fact_204_subset__trans,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A,C2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
     => ( ( ord_less_eq @ ( set @ A ) @ B @ C2 )
       => ( ord_less_eq @ ( set @ A ) @ A2 @ C2 ) ) ) ).

% subset_trans
thf(fact_205_set__eq__subset,axiom,
    ! [A: $tType] :
      ( ( ^ [Y4: set @ A,Z3: set @ A] : ( Y4 = Z3 ) )
      = ( ^ [A5: set @ A,B5: set @ A] :
            ( ( ord_less_eq @ ( set @ A ) @ A5 @ B5 )
            & ( ord_less_eq @ ( set @ A ) @ B5 @ A5 ) ) ) ) ).

% set_eq_subset
thf(fact_206_contra__subsetD,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A,C: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
     => ( ~ ( member2 @ A @ C @ B )
       => ~ ( member2 @ A @ C @ A2 ) ) ) ).

% contra_subsetD
thf(fact_207_Collect__mono__iff,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) )
      = ( ! [X2: A] :
            ( ( P @ X2 )
           => ( Q @ X2 ) ) ) ) ).

% Collect_mono_iff
thf(fact_208_subset__Collect__conv,axiom,
    ! [A: $tType,S: set @ A,P: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ S @ ( collect @ A @ P ) )
      = ( ! [X2: A] :
            ( ( member2 @ A @ X2 @ S )
           => ( P @ X2 ) ) ) ) ).

% subset_Collect_conv
thf(fact_209_longest__common__prefix,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
    ? [Ps: list @ A,Xs4: list @ A,Ys4: list @ A] :
      ( ( Xs
        = ( append @ A @ Ps @ Xs4 ) )
      & ( Ys
        = ( append @ A @ Ps @ Ys4 ) )
      & ( ( Xs4
          = ( nil @ A ) )
        | ( Ys4
          = ( nil @ A ) )
        | ( ( hd @ A @ Xs4 )
         != ( hd @ A @ Ys4 ) ) ) ) ).

% longest_common_prefix
thf(fact_210_list__match__lel__lel,axiom,
    ! [A: $tType,C1: list @ A,Qs: A,C22: list @ A,C12: list @ A,Qs2: A,C23: list @ A] :
      ( ( ( append @ A @ C1 @ ( cons @ A @ Qs @ C22 ) )
        = ( append @ A @ C12 @ ( cons @ A @ Qs2 @ C23 ) ) )
     => ( ! [C21: list @ A] :
            ( ( C1
              = ( append @ A @ C12 @ ( cons @ A @ Qs2 @ C21 ) ) )
           => ( C23
             != ( append @ A @ C21 @ ( cons @ A @ Qs @ C22 ) ) ) )
       => ( ( ( C12 = C1 )
           => ( ( Qs2 = Qs )
             => ( C23 != C22 ) ) )
         => ~ ! [C212: list @ A] :
                ( ( C12
                  = ( append @ A @ C1 @ ( cons @ A @ Qs @ C212 ) ) )
               => ( C22
                 != ( append @ A @ C212 @ ( cons @ A @ Qs2 @ C23 ) ) ) ) ) ) ) ).

% list_match_lel_lel
thf(fact_211_Cons__eq__appendI,axiom,
    ! [A: $tType,X: A,Xs1: list @ A,Ys: list @ A,Xs: list @ A,Zs: list @ A] :
      ( ( ( cons @ A @ X @ Xs1 )
        = Ys )
     => ( ( Xs
          = ( append @ A @ Xs1 @ Zs ) )
       => ( ( cons @ A @ X @ Xs )
          = ( append @ A @ Ys @ Zs ) ) ) ) ).

% Cons_eq_appendI
thf(fact_212_append__Cons,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Ys: list @ A] :
      ( ( append @ A @ ( cons @ A @ X @ Xs ) @ Ys )
      = ( cons @ A @ X @ ( append @ A @ Xs @ Ys ) ) ) ).

% append_Cons
thf(fact_213_append__eq__append__conv2,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,Zs: list @ A,Ts: list @ A] :
      ( ( ( append @ A @ Xs @ Ys )
        = ( append @ A @ Zs @ Ts ) )
      = ( ? [Us: list @ A] :
            ( ( ( Xs
                = ( append @ A @ Zs @ Us ) )
              & ( ( append @ A @ Us @ Ys )
                = Ts ) )
            | ( ( ( append @ A @ Xs @ Us )
                = Zs )
              & ( Ys
                = ( append @ A @ Us @ Ts ) ) ) ) ) ) ).

% append_eq_append_conv2
thf(fact_214_append__eq__appendI,axiom,
    ! [A: $tType,Xs: list @ A,Xs1: list @ A,Zs: list @ A,Ys: list @ A,Us2: list @ A] :
      ( ( ( append @ A @ Xs @ Xs1 )
        = Zs )
     => ( ( Ys
          = ( append @ A @ Xs1 @ Us2 ) )
       => ( ( append @ A @ Xs @ Ys )
          = ( append @ A @ Zs @ Us2 ) ) ) ) ).

% append_eq_appendI
thf(fact_215_append__Nil,axiom,
    ! [A: $tType,Ys: list @ A] :
      ( ( append @ A @ ( nil @ A ) @ Ys )
      = Ys ) ).

% append_Nil
thf(fact_216_eq__Nil__appendI,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( Xs = Ys )
     => ( Xs
        = ( append @ A @ ( nil @ A ) @ Ys ) ) ) ).

% eq_Nil_appendI
thf(fact_217_list_Osel_I1_J,axiom,
    ! [A: $tType,X21: A,X22: list @ A] :
      ( ( hd @ A @ ( cons @ A @ X21 @ X22 ) )
      = X21 ) ).

% list.sel(1)
thf(fact_218_list__append__eq__Cons__cases,axiom,
    ! [A: $tType,Ys: list @ A,Zs: list @ A,X: A,Xs: list @ A] :
      ( ( ( append @ A @ Ys @ Zs )
        = ( cons @ A @ X @ Xs ) )
     => ( ( ( Ys
            = ( nil @ A ) )
         => ( Zs
           != ( cons @ A @ X @ Xs ) ) )
       => ~ ! [Ys4: list @ A] :
              ( ( Ys
                = ( cons @ A @ X @ Ys4 ) )
             => ( ( append @ A @ Ys4 @ Zs )
               != Xs ) ) ) ) ).

% list_append_eq_Cons_cases
thf(fact_219_list__Cons__eq__append__cases,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Ys: list @ A,Zs: list @ A] :
      ( ( ( cons @ A @ X @ Xs )
        = ( append @ A @ Ys @ Zs ) )
     => ( ( ( Ys
            = ( nil @ A ) )
         => ( Zs
           != ( cons @ A @ X @ Xs ) ) )
       => ~ ! [Ys4: list @ A] :
              ( ( Ys
                = ( cons @ A @ X @ Ys4 ) )
             => ( ( append @ A @ Ys4 @ Zs )
               != Xs ) ) ) ) ).

% list_Cons_eq_append_cases
thf(fact_220_rev__nonempty__induct2_H,axiom,
    ! [A: $tType,B2: $tType,Xs: list @ A,Ys: list @ B2,P: ( list @ A ) > ( list @ B2 ) > $o] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( Ys
         != ( nil @ B2 ) )
       => ( ! [X3: A,Y3: B2] : ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) @ ( cons @ B2 @ Y3 @ ( nil @ B2 ) ) )
         => ( ! [X3: A,Xs2: list @ A,Y3: B2] :
                ( ( Xs2
                 != ( nil @ A ) )
               => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) @ ( cons @ B2 @ Y3 @ ( nil @ B2 ) ) ) )
           => ( ! [X3: A,Y3: B2,Ys2: list @ B2] :
                  ( ( Ys2
                   != ( nil @ B2 ) )
                 => ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) @ ( append @ B2 @ Ys2 @ ( cons @ B2 @ Y3 @ ( nil @ B2 ) ) ) ) )
             => ( ! [X3: A,Xs2: list @ A,Y3: B2,Ys2: list @ B2] :
                    ( ( P @ Xs2 @ Ys2 )
                   => ( ( Xs2
                       != ( nil @ A ) )
                     => ( ( Ys2
                         != ( nil @ B2 ) )
                       => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) @ ( append @ B2 @ Ys2 @ ( cons @ B2 @ Y3 @ ( nil @ B2 ) ) ) ) ) ) )
               => ( P @ Xs @ Ys ) ) ) ) ) ) ) ).

% rev_nonempty_induct2'
thf(fact_221_rev__nonempty__induct,axiom,
    ! [A: $tType,Xs: list @ A,P: ( list @ A ) > $o] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ! [X3: A] : ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X3: A,Xs2: list @ A] :
              ( ( Xs2
               != ( nil @ A ) )
             => ( ( P @ Xs2 )
               => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% rev_nonempty_induct
thf(fact_222_append__eq__Cons__conv,axiom,
    ! [A: $tType,Ys: list @ A,Zs: list @ A,X: A,Xs: list @ A] :
      ( ( ( append @ A @ Ys @ Zs )
        = ( cons @ A @ X @ Xs ) )
      = ( ( ( Ys
            = ( nil @ A ) )
          & ( Zs
            = ( cons @ A @ X @ Xs ) ) )
        | ? [Ys5: list @ A] :
            ( ( Ys
              = ( cons @ A @ X @ Ys5 ) )
            & ( ( append @ A @ Ys5 @ Zs )
              = Xs ) ) ) ) ).

% append_eq_Cons_conv
thf(fact_223_Cons__eq__append__conv,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Ys: list @ A,Zs: list @ A] :
      ( ( ( cons @ A @ X @ Xs )
        = ( append @ A @ Ys @ Zs ) )
      = ( ( ( Ys
            = ( nil @ A ) )
          & ( ( cons @ A @ X @ Xs )
            = Zs ) )
        | ? [Ys5: list @ A] :
            ( ( ( cons @ A @ X @ Ys5 )
              = Ys )
            & ( Xs
              = ( append @ A @ Ys5 @ Zs ) ) ) ) ) ).

% Cons_eq_append_conv
thf(fact_224_neq__Nil__rev__conv,axiom,
    ! [A: $tType,L: list @ A] :
      ( ( L
       != ( nil @ A ) )
      = ( ? [Xs3: list @ A,X2: A] :
            ( L
            = ( append @ A @ Xs3 @ ( cons @ A @ X2 @ ( nil @ A ) ) ) ) ) ) ).

% neq_Nil_rev_conv
thf(fact_225_list__rev__decomp,axiom,
    ! [A: $tType,L: list @ A] :
      ( ( L
       != ( nil @ A ) )
     => ? [Ll: list @ A,E2: A] :
          ( L
          = ( append @ A @ Ll @ ( cons @ A @ E2 @ ( nil @ A ) ) ) ) ) ).

% list_rev_decomp
thf(fact_226_rev__induct2_H,axiom,
    ! [A: $tType,B2: $tType,P: ( list @ A ) > ( list @ B2 ) > $o,Xs: list @ A,Ys: list @ B2] :
      ( ( P @ ( nil @ A ) @ ( nil @ B2 ) )
     => ( ! [X3: A,Xs2: list @ A] : ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) @ ( nil @ B2 ) )
       => ( ! [Y3: B2,Ys2: list @ B2] : ( P @ ( nil @ A ) @ ( append @ B2 @ Ys2 @ ( cons @ B2 @ Y3 @ ( nil @ B2 ) ) ) )
         => ( ! [X3: A,Xs2: list @ A,Y3: B2,Ys2: list @ B2] :
                ( ( P @ Xs2 @ Ys2 )
               => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) @ ( append @ B2 @ Ys2 @ ( cons @ B2 @ Y3 @ ( nil @ B2 ) ) ) ) )
           => ( P @ Xs @ Ys ) ) ) ) ) ).

% rev_induct2'
thf(fact_227_rev__exhaust,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ~ ! [Ys2: list @ A,Y3: A] :
            ( Xs
           != ( append @ A @ Ys2 @ ( cons @ A @ Y3 @ ( nil @ A ) ) ) ) ) ).

% rev_exhaust
thf(fact_228_rev__induct,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,Xs: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X3: A,Xs2: list @ A] :
            ( ( P @ Xs2 )
           => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) ) )
       => ( P @ Xs ) ) ) ).

% rev_induct
thf(fact_229_split__list__first__prop__iff,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ( ? [X2: A] :
            ( ( member2 @ A @ X2 @ ( set2 @ A @ Xs ) )
            & ( P @ X2 ) ) )
      = ( ? [Ys3: list @ A,X2: A] :
            ( ? [Zs2: list @ A] :
                ( Xs
                = ( append @ A @ Ys3 @ ( cons @ A @ X2 @ Zs2 ) ) )
            & ( P @ X2 )
            & ! [Y2: A] :
                ( ( member2 @ A @ Y2 @ ( set2 @ A @ Ys3 ) )
               => ~ ( P @ Y2 ) ) ) ) ) ).

% split_list_first_prop_iff
thf(fact_230_split__list__last__prop__iff,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ( ? [X2: A] :
            ( ( member2 @ A @ X2 @ ( set2 @ A @ Xs ) )
            & ( P @ X2 ) ) )
      = ( ? [Ys3: list @ A,X2: A,Zs2: list @ A] :
            ( ( Xs
              = ( append @ A @ Ys3 @ ( cons @ A @ X2 @ Zs2 ) ) )
            & ( P @ X2 )
            & ! [Y2: A] :
                ( ( member2 @ A @ Y2 @ ( set2 @ A @ Zs2 ) )
               => ~ ( P @ Y2 ) ) ) ) ) ).

% split_list_last_prop_iff
thf(fact_231_in__set__conv__decomp__first,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
      = ( ? [Ys3: list @ A,Zs2: list @ A] :
            ( ( Xs
              = ( append @ A @ Ys3 @ ( cons @ A @ X @ Zs2 ) ) )
            & ~ ( member2 @ A @ X @ ( set2 @ A @ Ys3 ) ) ) ) ) ).

% in_set_conv_decomp_first
thf(fact_232_in__set__conv__decomp__last,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
      = ( ? [Ys3: list @ A,Zs2: list @ A] :
            ( ( Xs
              = ( append @ A @ Ys3 @ ( cons @ A @ X @ Zs2 ) ) )
            & ~ ( member2 @ A @ X @ ( set2 @ A @ Zs2 ) ) ) ) ) ).

% in_set_conv_decomp_last
thf(fact_233_split__list__first__propE,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ? [X4: A] :
          ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P @ X4 ) )
     => ~ ! [Ys2: list @ A,X3: A] :
            ( ? [Zs3: list @ A] :
                ( Xs
                = ( append @ A @ Ys2 @ ( cons @ A @ X3 @ Zs3 ) ) )
           => ( ( P @ X3 )
             => ~ ! [Xa: A] :
                    ( ( member2 @ A @ Xa @ ( set2 @ A @ Ys2 ) )
                   => ~ ( P @ Xa ) ) ) ) ) ).

% split_list_first_propE
thf(fact_234_split__list__last__propE,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ? [X4: A] :
          ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P @ X4 ) )
     => ~ ! [Ys2: list @ A,X3: A,Zs3: list @ A] :
            ( ( Xs
              = ( append @ A @ Ys2 @ ( cons @ A @ X3 @ Zs3 ) ) )
           => ( ( P @ X3 )
             => ~ ! [Xa: A] :
                    ( ( member2 @ A @ Xa @ ( set2 @ A @ Zs3 ) )
                   => ~ ( P @ Xa ) ) ) ) ) ).

% split_list_last_propE
thf(fact_235_split__list__first__prop,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ? [X4: A] :
          ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P @ X4 ) )
     => ? [Ys2: list @ A,X3: A] :
          ( ? [Zs3: list @ A] :
              ( Xs
              = ( append @ A @ Ys2 @ ( cons @ A @ X3 @ Zs3 ) ) )
          & ( P @ X3 )
          & ! [Xa: A] :
              ( ( member2 @ A @ Xa @ ( set2 @ A @ Ys2 ) )
             => ~ ( P @ Xa ) ) ) ) ).

% split_list_first_prop
thf(fact_236_split__list__last__prop,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ? [X4: A] :
          ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P @ X4 ) )
     => ? [Ys2: list @ A,X3: A,Zs3: list @ A] :
          ( ( Xs
            = ( append @ A @ Ys2 @ ( cons @ A @ X3 @ Zs3 ) ) )
          & ( P @ X3 )
          & ! [Xa: A] :
              ( ( member2 @ A @ Xa @ ( set2 @ A @ Zs3 ) )
             => ~ ( P @ Xa ) ) ) ) ).

% split_list_last_prop
thf(fact_237_in__set__conv__decomp,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
      = ( ? [Ys3: list @ A,Zs2: list @ A] :
            ( Xs
            = ( append @ A @ Ys3 @ ( cons @ A @ X @ Zs2 ) ) ) ) ) ).

% in_set_conv_decomp
thf(fact_238_split__list__propE,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ? [X4: A] :
          ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P @ X4 ) )
     => ~ ! [Ys2: list @ A,X3: A] :
            ( ? [Zs3: list @ A] :
                ( Xs
                = ( append @ A @ Ys2 @ ( cons @ A @ X3 @ Zs3 ) ) )
           => ~ ( P @ X3 ) ) ) ).

% split_list_propE
thf(fact_239_split__list__first,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
     => ? [Ys2: list @ A,Zs3: list @ A] :
          ( ( Xs
            = ( append @ A @ Ys2 @ ( cons @ A @ X @ Zs3 ) ) )
          & ~ ( member2 @ A @ X @ ( set2 @ A @ Ys2 ) ) ) ) ).

% split_list_first
thf(fact_240_split__list__prop,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ? [X4: A] :
          ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P @ X4 ) )
     => ? [Ys2: list @ A,X3: A] :
          ( ? [Zs3: list @ A] :
              ( Xs
              = ( append @ A @ Ys2 @ ( cons @ A @ X3 @ Zs3 ) ) )
          & ( P @ X3 ) ) ) ).

% split_list_prop
thf(fact_241_split__list__last,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
     => ? [Ys2: list @ A,Zs3: list @ A] :
          ( ( Xs
            = ( append @ A @ Ys2 @ ( cons @ A @ X @ Zs3 ) ) )
          & ~ ( member2 @ A @ X @ ( set2 @ A @ Zs3 ) ) ) ) ).

% split_list_last
thf(fact_242_split__list,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
     => ? [Ys2: list @ A,Zs3: list @ A] :
          ( Xs
          = ( append @ A @ Ys2 @ ( cons @ A @ X @ Zs3 ) ) ) ) ).

% split_list
thf(fact_243_in__set__list__format,axiom,
    ! [A: $tType,E: A,L: list @ A] :
      ( ( member2 @ A @ E @ ( set2 @ A @ L ) )
     => ~ ! [L12: list @ A,L22: list @ A] :
            ( L
           != ( append @ A @ L12 @ ( cons @ A @ E @ L22 ) ) ) ) ).

% in_set_list_format
thf(fact_244_xy__in__set__cases,axiom,
    ! [A: $tType,X: A,L: list @ A,Y: A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ L ) )
     => ( ( member2 @ A @ Y @ ( set2 @ A @ L ) )
       => ( ( ( X = Y )
           => ! [L12: list @ A,L22: list @ A] :
                ( L
               != ( append @ A @ L12 @ ( cons @ A @ Y @ L22 ) ) ) )
         => ( ( ( X != Y )
             => ! [L12: list @ A,L22: list @ A,L3: list @ A] :
                  ( L
                 != ( append @ A @ L12 @ ( cons @ A @ X @ ( append @ A @ L22 @ ( cons @ A @ Y @ L3 ) ) ) ) ) )
           => ~ ( ( X != Y )
               => ! [L12: list @ A,L22: list @ A,L3: list @ A] :
                    ( L
                   != ( append @ A @ L12 @ ( cons @ A @ Y @ ( append @ A @ L22 @ ( cons @ A @ X @ L3 ) ) ) ) ) ) ) ) ) ) ).

% xy_in_set_cases
thf(fact_245_distinct__match,axiom,
    ! [A: $tType,Al: list @ A,E: A,Bl: list @ A,Al2: list @ A,Bl2: list @ A] :
      ( ( distinct @ A @ ( append @ A @ Al @ ( cons @ A @ E @ Bl ) ) )
     => ( ( ( append @ A @ Al @ ( cons @ A @ E @ Bl ) )
          = ( append @ A @ Al2 @ ( cons @ A @ E @ Bl2 ) ) )
        = ( ( Al = Al2 )
          & ( Bl = Bl2 ) ) ) ) ).

% distinct_match
thf(fact_246_list_Oset__sel_I1_J,axiom,
    ! [A: $tType,A3: list @ A] :
      ( ( A3
       != ( nil @ A ) )
     => ( member2 @ A @ ( hd @ A @ A3 ) @ ( set2 @ A @ A3 ) ) ) ).

% list.set_sel(1)
thf(fact_247_hd__in__set,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( member2 @ A @ ( hd @ A @ Xs ) @ ( set2 @ A @ Xs ) ) ) ).

% hd_in_set
thf(fact_248_list__ex1__iff,axiom,
    ! [A: $tType] :
      ( ( list_ex1 @ A )
      = ( ^ [P3: A > $o,Xs3: list @ A] :
          ? [X2: A] :
            ( ( member2 @ A @ X2 @ ( set2 @ A @ Xs3 ) )
            & ( P3 @ X2 )
            & ! [Y2: A] :
                ( ( ( member2 @ A @ Y2 @ ( set2 @ A @ Xs3 ) )
                  & ( P3 @ Y2 ) )
               => ( Y2 = X2 ) ) ) ) ) ).

% list_ex1_iff
thf(fact_249_not__distinct__decomp,axiom,
    ! [A: $tType,Ws: list @ A] :
      ( ~ ( distinct @ A @ Ws )
     => ? [Xs2: list @ A,Ys2: list @ A,Zs3: list @ A,Y3: A] :
          ( Ws
          = ( append @ A @ Xs2 @ ( append @ A @ ( cons @ A @ Y3 @ ( nil @ A ) ) @ ( append @ A @ Ys2 @ ( append @ A @ ( cons @ A @ Y3 @ ( nil @ A ) ) @ Zs3 ) ) ) ) ) ) ).

% not_distinct_decomp
thf(fact_250_sorted__append,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,Ys: list @ A] :
          ( ( linorder_sorted @ A @ ( append @ A @ Xs @ Ys ) )
          = ( ( linorder_sorted @ A @ Xs )
            & ( linorder_sorted @ A @ Ys )
            & ! [X2: A] :
                ( ( member2 @ A @ X2 @ ( set2 @ A @ Xs ) )
               => ! [Y2: A] :
                    ( ( member2 @ A @ Y2 @ ( set2 @ A @ Ys ) )
                   => ( ord_less_eq @ A @ X2 @ Y2 ) ) ) ) ) ) ).

% sorted_append
thf(fact_251_not__distinct__conv__prefix,axiom,
    ! [A: $tType,As2: list @ A] :
      ( ( ~ ( distinct @ A @ As2 ) )
      = ( ? [Xs3: list @ A,Y2: A,Ys3: list @ A] :
            ( ( member2 @ A @ Y2 @ ( set2 @ A @ Xs3 ) )
            & ( distinct @ A @ Xs3 )
            & ( As2
              = ( append @ A @ Xs3 @ ( cons @ A @ Y2 @ Ys3 ) ) ) ) ) ) ).

% not_distinct_conv_prefix
thf(fact_252_not__distinct__split__distinct,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ~ ( distinct @ A @ Xs )
     => ~ ! [Y3: A,Ys2: list @ A] :
            ( ( distinct @ A @ Ys2 )
           => ( ( member2 @ A @ Y3 @ ( set2 @ A @ Ys2 ) )
             => ! [Zs3: list @ A] :
                  ( Xs
                 != ( append @ A @ Ys2 @ ( append @ A @ ( cons @ A @ Y3 @ ( nil @ A ) ) @ Zs3 ) ) ) ) ) ) ).

% not_distinct_split_distinct
thf(fact_253_can__select__set__list__ex1,axiom,
    ! [A: $tType,P: A > $o,A2: list @ A] :
      ( ( can_select @ A @ P @ ( set2 @ A @ A2 ) )
      = ( list_ex1 @ A @ P @ A2 ) ) ).

% can_select_set_list_ex1
thf(fact_254_sublists_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( sublists @ A @ ( nil @ A ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% sublists.simps(1)

%----Subclasses (4)
thf(subcl_Orderings_Olinorder___HOL_Otype,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( type @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Oord,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( ord @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Oorder,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( order @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Opreorder,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( preorder @ A @ ( type2 @ A ) ) ) ).

%----Type constructors (16)
thf(tcon_fun___Lattices_Osemilattice__inf,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( semilattice_inf @ A8 @ ( type2 @ A8 ) )
     => ( semilattice_inf @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( preorder @ A8 @ ( type2 @ A8 ) )
     => ( preorder @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Lattices_Olattice,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( lattice @ A8 @ ( type2 @ A8 ) )
     => ( lattice @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( order @ A8 @ ( type2 @ A8 ) )
     => ( order @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( ord @ A8 @ ( type2 @ A8 ) )
     => ( ord @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_Set_Oset___Lattices_Osemilattice__inf_1,axiom,
    ! [A7: $tType] : ( semilattice_inf @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Opreorder_2,axiom,
    ! [A7: $tType] : ( preorder @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Lattices_Olattice_3,axiom,
    ! [A7: $tType] : ( lattice @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder_4,axiom,
    ! [A7: $tType] : ( order @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oord_5,axiom,
    ! [A7: $tType] : ( ord @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_HOL_Obool___Lattices_Osemilattice__inf_6,axiom,
    semilattice_inf @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Opreorder_7,axiom,
    preorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder,axiom,
    linorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Lattices_Olattice_8,axiom,
    lattice @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oorder_9,axiom,
    order @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oord_10,axiom,
    ord @ $o @ ( type2 @ $o ) ).

%----Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X: A,Y: A] :
      ( ( if @ A @ $false @ X @ Y )
      = Y ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X: A,Y: A] :
      ( ( if @ A @ $true @ X @ Y )
      = X ) ).

%----Free types (1)
thf(tfree_0,hypothesis,
    linorder @ a @ ( type2 @ a ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    ( ( distinct @ a @ ( sorted2037043510sorted @ a @ ( cons @ a @ x1 @ l1a ) @ ( cons @ a @ x2 @ l2b ) ) )
    & ( linorder_sorted @ a @ ( sorted2037043510sorted @ a @ ( cons @ a @ x1 @ l1a ) @ ( cons @ a @ x2 @ l2b ) ) )
    & ( ( set2 @ a @ ( sorted2037043510sorted @ a @ ( cons @ a @ x1 @ l1a ) @ ( cons @ a @ x2 @ l2b ) ) )
      = ( inf_inf @ ( set @ a ) @ ( set2 @ a @ ( cons @ a @ x1 @ l1a ) ) @ ( set2 @ a @ ( cons @ a @ x2 @ l2b ) ) ) ) ) ).

%------------------------------------------------------------------------------
